/*
 * FlowFinishedListener.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.event;


/**
 * Interface for classes that listen for changes in the state of flow setups, 
 * like starting a flow, finishing, etc.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 628 $
 */
public interface FlowSetupStateListener {

  /**
   * Gets called when the state of the flow setup changed.
   * 
   * @param e		the event
   */
  public void flowSetupStateChanged(FlowSetupStateEvent e);
}
