/**
 * GraphicalOutputProducingProcessor.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.processor;

import java.awt.Component;

/**
 * Interface for processors that can generate graphical output.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3482 $
 */
public interface GraphicalOutputProducingProcessor {

  /**
   * Returns whether graphical output was generated.
   *
   * @return		true if graphical output was generated
   */
  public boolean hasGraphicalOutput();

  /**
   * Returns the graphical output that was generated.
   *
   * @return		the graphical output
   */
  public Component getGraphicalOutput();
}
