/**
 * SelectionAwareEditorTab.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.flow.tab;

import javax.swing.tree.TreePath;

import adams.flow.core.AbstractActor;

/**
 * Interface for flow editor tabs that need to react to changes of
 * currently selected actors.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4050 $
 */
public interface SelectionAwareEditorTab {

  /**
   * Notifies the tab of the currently selected actors.
   *
   * @param paths	the selected paths
   * @param actors	the currently selected actors
   */
  public void actorSelectionChanged(TreePath[] paths, AbstractActor[] actors);
}
