/**
 * ClassTreeNodeCollection.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.goe.classtree;

import java.awt.datatransfer.Transferable;

import adams.gui.core.DragAndDropTreeNodeCollection;
import adams.gui.core.TransferableString;

/**
 * Node collection for the class tree.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3746 $
 */
public class ClassTreeNodeCollection
  extends DragAndDropTreeNodeCollection<ClassNode> {

  /** for serialization. */
  private static final long serialVersionUID = 8624532382080344377L;

  /**
   * Initializes the collection with all the nodes.
   *
   * @param nodes	the nodes for the collection
   */
  public ClassTreeNodeCollection(ClassNode[] nodes) {
    super(nodes);
  }

  /**
   * Turns the node/userObject into a transferable string.
   * Uses only the first node.
   *
   * @return		the generated string
   */
  public Transferable toTransferable() {
    return new TransferableString(m_Nodes.get(0).getItem());
  }
}
