/*
 * JVisualVM.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import javax.swing.JOptionPane;

import adams.core.management.ProcessUtils;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;

/**
 * Starts up jvisualvm.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2665 $
 * @see adams.core.management.JVisualVM
 */
public class JVisualVM
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 5160350971358567707L;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public JVisualVM(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "duke.png";
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    // query for options
    String options = JOptionPane.showInputDialog(
	null, "Enter the options for " + adams.core.management.JVisualVM.EXECUTABLE + ":",
	adams.core.management.JVisualVM.getDefaultOptions());
    if (options == null)
      return;

    final long fPid = ProcessUtils.getVirtualMachinePID();
    final String fOptions = options;
    Thread thread = new Thread(new Runnable() {
      public void run() {
	adams.core.management.JVisualVM.execute(fOptions, fPid);
      }
    });
    thread.start();
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "JVisualVM";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return true;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.DEVELOPER;
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return CATEGORY_HELP;
  }
}