/**
 * AbstractDatabaseScriptlet.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import adams.db.AbstractDatabaseConnection;

/**
 * Ancestor for scriptlets that need access to the database.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public abstract class AbstractDatabaseScriptlet
  extends AbstractScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = -7051048031205784713L;

  /**
   * Returns the database connection instance.
   *
   * @return		the connection object
   */
  protected AbstractDatabaseConnection getDatabaseConnection() {
    return getOwner().getDatabaseConnection();
  }
}
