/*
 * OutputFileGenerator.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.tools;

import adams.core.io.PlaceholderFile;

/**
 * For tools that generate an output file.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 25 $
 */
public interface OutputFileGenerator {

  /**
   * Set output file.
   * 
   * @param value	file
   */
  public void setOutputFile(PlaceholderFile value);
  
  /**
   * Get output file.
   * 
   * @return	file
   */
  public PlaceholderFile getOutputFile();
  
  /**
   * Returns the tip text for this property.
   * 
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String outputFileTipText();
}
