/*
 * TableUpgrade.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.tools;

import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.upgrade.AbstractTableUpgrade;
import adams.db.upgrade.PassThrough;

/**
 <!-- globalinfo-start -->
 * Tool for running a specific table upgrade.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 * <pre>-upgrade &lt;adams.db.upgrade.AbstractTableUpgrade [options]&gt; (property: tableUpgrade)
 *         The table upgrade scheme to use.
 *         default: adams.db.upgrade.PassThrough
 * </pre>
 *
 * Default options for adams.db.upgrade.PassThrough (-upgrade/tableUpgrade):
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 <!-- options-end -->
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class TableUpgrade
  extends AbstractDatabaseTool {

  /** for serialization. */
  private static final long serialVersionUID = -1179186237647446679L;

  /** the table upgrade to run. */
  protected AbstractTableUpgrade m_TableUpgrade;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Tool for running a specific table upgrade.";
  }

  /**
   * Adds options to the internal list of options.
   */
  public void defineOptions() {
    super.defineOptions();

    m_OptionManager.add(
	    "upgrade", "tableUpgrade",
	    new PassThrough());
  }

  /**
   * Returns the default database connection.
   *
   * @return		the database connection
   */
  protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
    return DatabaseConnection.getSingleton();
  }

  /**
   * Sets the table upgrade to use.
   *
   * @param value	the table upgrade to use
   */
  public void setTableUpgrade(AbstractTableUpgrade value) {
    m_TableUpgrade = value;
  }

  /**
   * Returns the table upgrade to use.
   *
   * @return		the table upgrade to use
   */
  public AbstractTableUpgrade getTableUpgrade() {
    return m_TableUpgrade;
  }

  /**
   * Returns the tip text for this property.
   *
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String tableUpgradeTipText() {
    return "The table upgrade scheme to use.";
  }

  /**
   * Attempt to run the table upgrade scheme.
   */
  protected void doRun() {
    StringBuffer	info;

    m_TableUpgrade.setDatabaseConnection(getDatabaseConnection());
    info = m_TableUpgrade.upgrade();
    getSystemOut().println(info.toString());
  }
}
