/**
 * StringOptionTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Test class for all string options. Run from the command line with: <p/>
 * java adams.core.option.StringOptionTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2388 $
 */
public class StringOptionTest
  extends AbstractArgumentOptionTest {

  /**
   * Dummy class for testing byte options.
   *
   * @author  fracpete (fracpete at waikato dot ac dot nz)
   * @version $Revision: 2388 $
   */
  public static class StringOptionClass
    extends AbstractOptionClass {

    /** for serialization. */
    private static final long serialVersionUID = 5861574574955490382L;

    protected String m_String;

    protected String[] m_StringArray;

    /**
     * Adds options to the internal list of options.
     */
    public void defineOptions() {
      super.defineOptions();

      m_OptionManager.add(
	  "string", "string",
      "1");

      m_OptionManager.add(
	  "string-array", "stringArray",
	  new String[]{"1", "2", "3"});
    }

    public void setString(String value) {
      m_String = value;
    }

    public String getString() {
      return m_String;
    }

    public String stringTipText() {
      return "string";
    }

    public void setStringArray(String[] value) {
      m_StringArray = value;
    }

    public String[] getStringArray() {
      return m_StringArray;
    }

    public String stringArrayTipText() {
      return "stringArray";
    }
  }

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public StringOptionTest(String name) {
    super(name);
  }

  /**
   * Returns the fully setup dummy object to test.
   *
   * @return		the object to use for testing the options
   */
  protected OptionHandler getOptionHandler() {
    return new StringOptionClass();
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(StringOptionTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
