/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.AbstractSpreadSheetReader;
import adams.core.io.FileUtils;
import adams.core.io.SpreadSheet;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractSpreadSheetReaderTestCase
extends AdamsTestCase {
    public AbstractSpreadSheetReaderTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/core/io/data");
    }

    protected SpreadSheet load(String filename, AbstractSpreadSheetReader scheme) {
        this.m_TestHelper.copyResourceToTmp(filename);
        SpreadSheet result = scheme.read((File)((Object)new TmpFile(filename)));
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractSpreadSheetReader[] getRegressionSetups();

    protected boolean save(SpreadSheet data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data, (boolean)false);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractSpreadSheetReader[] setups = this.getRegressionSetups();
        AbstractSpreadSheetReaderTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            SpreadSheet data = this.load(input[i], setups[i]);
            AbstractSpreadSheetReaderTestCase.assertNotNull((String)"Failed to load data?", (Object)data);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(data, output[i]);
            AbstractSpreadSheetReaderTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractSpreadSheetReaderTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

