/*
 * Decompiled with CFR 0.152.
 */
package adams.data.id;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.data.id.AbstractIDGenerator;
import adams.data.id.IDHandler;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractIDGeneratorTestCase<D extends DataContainer & IDHandler>
extends AdamsTestCase {
    public AbstractIDGeneratorTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/id/data");
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractIDGenerator[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected abstract D[] load(String var1);

    protected boolean save(String[] data, String filename) {
        return FileUtils.saveToFile((String[])data, (File)((Object)new TmpFile(filename)));
    }

    protected String[] process(D[] data, AbstractIDGenerator scheme) {
        String[] result = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = scheme.generate(data[i]);
        }
        return result;
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractIDGenerator[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        AbstractIDGeneratorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            DataContainer[] data = this.load(input[i]);
            AbstractIDGeneratorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            AbstractIDGenerator current = setups[i].shallowCopy();
            AbstractIDGeneratorTestCase.assertNotNull((String)("Failed to create copy of ID generator: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            String[] processed = this.process(data, current);
            AbstractIDGeneratorTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractIDGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractIDGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

