/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.db.DatabaseConnectionHandler;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.Vector;

public abstract class AbstractOutlierDetectorTestCase<T extends DataContainer>
extends AbstractDatabaseTestCase {
    public AbstractOutlierDetectorTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/outlier/data");
    }

    protected T load(String filename) {
        return null;
    }

    protected Vector<String> process(T data, AbstractOutlierDetector scheme) {
        return scheme.detect(data);
    }

    protected boolean save(Vector<String> data, String filename) {
        return FileUtils.saveToFile(data, (File)new File(this.m_TestHelper.getTmpDirectory() + File.separator + filename));
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractOutlierDetector[] getRegressionSetups();

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractOutlierDetector[] setups = this.getRegressionSetups();
        AbstractOutlierDetectorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            T data = this.load(input[i]);
            AbstractOutlierDetectorTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), data);
            if (setups[i] instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)setups[i]).setDatabaseConnection(this.getDatabaseConnection());
            }
            Vector<String> processed = this.process(data, setups[i]);
            AbstractOutlierDetectorTestCase.assertNotNull((String)"Failed to process data?", processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractOutlierDetectorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractOutlierDetectorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

