/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.DoubleToString;
import adams.data.conversion.IntToDouble;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.ForLoop;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.Convert;
import adams.flow.transformer.MathExpression;
import adams.flow.transformer.SequenceToArray;
import adams.flow.transformer.StringReplace;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ArrayProcessTest
extends AbstractFlowTest {
    public ArrayProcessTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        ForLoop fl = new ForLoop();
        fl.setLoopLower(1);
        fl.setLoopUpper(30);
        fl.setLoopStep(1);
        IntToDouble i2d = new IntToDouble();
        Convert con1 = new Convert();
        con1.setConversion((AbstractConversion)i2d);
        SequenceToArray s2a = new SequenceToArray();
        s2a.setArrayLength(30);
        ArrayProcess sub = new ArrayProcess();
        MathExpression me = new MathExpression();
        me.setExpression("X^2");
        DoubleToString d2s = new DoubleToString();
        Convert con2 = new Convert();
        con2.setConversion((AbstractConversion)d2s);
        StringReplace sr = new StringReplace();
        sr.setFind(new BaseRegExp("$"));
        sr.setReplace("-blah");
        sub.setActors(new AbstractActor[]{me, con2, sr});
        ArrayToSequence a2s = new ArrayToSequence();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{fl, con1, s2a, sub, a2s, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(ArrayProcessTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ArrayProcessTest.runTest(ArrayProcessTest.suite());
    }
}

