/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Placeholders;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;
import adams.flow.transformer.StringReplace;
import adams.test.TmpFile;
import java.io.File;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StringReplaceTest
extends AbstractFlowTest {
    public StringReplaceTest(String name) {
        super(name);
    }

    @Override
    public AbstractActor getActor() {
        StringConstants con = new StringConstants();
        con.setStrings(new BaseString[]{new BaseString("ABCDEF"), new BaseString("ABDEF"), new BaseString("BCDEF"), new BaseString("bcDEF ")});
        StringReplace actor = new StringReplace();
        actor.setFind(new BaseRegExp("BC"));
        actor.setReplace("--");
        Null nul = new Null();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{con, actor, nul});
        return flow;
    }

    protected void performTest(String[] strIn, String[] strOut, String find, String replace, boolean replaceAll, boolean contPl, String[][] vars) {
        Flow flow = new Flow();
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                flow.getVariables().set(vars[i][0], vars[i][1]);
            }
        }
        StringConstants sc = new StringConstants();
        BaseString[] bs = new BaseString[strIn.length];
        for (int i = 0; i < strIn.length; ++i) {
            bs[i] = new BaseString(strIn[i]);
        }
        sc.setStrings(bs);
        StringReplace actor = new StringReplace();
        actor.setFind(new BaseRegExp(find));
        actor.setReplace(replace);
        actor.setReplaceAll(replaceAll);
        actor.setReplaceContainsPlaceholder(contPl);
        actor.setReplaceContainsVariable(vars != null);
        TmpFile outFile = new TmpFile("dumpfile.txt");
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)outFile);
        df.setAppend(true);
        flow.setActors(new AbstractActor[]{sc, actor, df});
        FileUtils.delete((File)((Object)outFile));
        StringReplaceTest.assertNull((String)"problem with setUp()", (Object)flow.setUp());
        StringReplaceTest.assertNull((String)"problem with execute()", (Object)flow.execute());
        Vector vecOutActor = FileUtils.loadFromFile((File)((Object)outFile));
        String[] strOutActor = vecOutActor.toArray(new String[vecOutActor.size()]);
        StringReplaceTest.assertEquals((String)"array length differs", (int)strOut.length, (int)strOutActor.length);
        for (int i = 0; i < strOut.length; ++i) {
            StringReplaceTest.assertEquals((String)"values differ", (String)strOut[i], (String)strOutActor[i]);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorReplaceFirst() {
        String[] strIn = new String[]{"ABCDEFBC", "ABDEF", "BCDEFBC", "bcDEFbc"};
        String[] strOut = new String[]{"A--DEFBC", "ABDEF", "--DEFBC", "bcDEFbc"};
        this.performTest(strIn, strOut, "BC", "--", false, false, null);
    }

    public void testActorReplaceAll() {
        String[] strIn = new String[]{"ABCDEFBC", "ABDEF", "BCDEFBC", "bcDEFbc"};
        String[] strOut = new String[]{"A--DEF--", "ABDEF", "--DEF--", "bcDEFbc"};
        this.performTest(strIn, strOut, "BC", "--", true, false, null);
    }

    public void testActorReplaceAllPlaceholders() {
        Placeholders.getSingleton().set("JUNITBLAH", "hello_world");
        String[] strIn = new String[]{"ABCDEFBC", "BCABDEF"};
        String[] strOut = new String[]{"Ahello_worldDEFhello_world", "hello_worldABDEF"};
        this.performTest(strIn, strOut, "BC", "${JUNITBLAH}", true, true, null);
    }

    public void testActorReplaceAllVariables() {
        String[] strIn = new String[]{"ABCDEFBC", "BCABDEF"};
        String[] strOut = new String[]{"Ahello_worldDEFhello_world", "hello_worldABDEF"};
        this.performTest(strIn, strOut, "BC", "@{blah}", true, false, new String[][]{{"blah", "hello_world"}});
    }

    public void testActorReplaceAllPlaceholdersAndVariables() {
        Placeholders.getSingleton().set("JUNITBLAH", "hello_world");
        String[] strIn = new String[]{"ABCDEFBC", "BCABDEF"};
        String[] strOut = new String[]{"Ahello_worldDEFhello_world", "hello_worldABDEF"};
        this.performTest(strIn, strOut, "BC", "@{blah}", true, true, new String[][]{{"blah", "${JUNITBLAH}"}});
    }

    public static Test suite() {
        return new TestSuite(StringReplaceTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StringReplaceTest.runTest(StringReplaceTest.suite());
    }
}

