/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.statistics.StatUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class Max
extends AbstractTransformer {
    private static final long serialVersionUID = 2007764064808349672L;
    protected boolean m_ReturnIndex;

    @Override
    public String globalInfo() {
        return "Returns the maximum value from a double/int array or the index of the maximum value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "returnIndex", false);
    }

    @Override
    public String getQuickInfo() {
        if (this.m_ReturnIndex) {
            return "Index";
        }
        return "Value";
    }

    public void setReturnIndex(boolean value) {
        this.m_ReturnIndex = value;
        this.reset();
    }

    public boolean getReturnIndex() {
        return this.m_ReturnIndex;
    }

    public String returnIndexTipText() {
        return "If set to true, then the index of the maximum is returned instead of the value.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Integer[].class, Double[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Integer.class, Double.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken.getPayload() instanceof Double[]) {
                Number[] doubles = (Double[])this.m_InputToken.getPayload();
                this.m_OutputToken = this.m_ReturnIndex ? new Token(new Integer(StatUtils.maxIndex(doubles))) : new Token((Double)StatUtils.max(doubles));
            } else {
                Number[] integers = (Integer[])this.m_InputToken.getPayload();
                this.m_OutputToken = this.m_ReturnIndex ? new Token(new Integer(StatUtils.maxIndex(integers))) : new Token((Integer)StatUtils.max(integers));
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.getSystemErr().printStackTrace(e);
            result = e.toString();
        }
        return result;
    }
}

