/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.Placeholders;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.chooser.BaseDirectoryChooser;
import java.io.File;

public class DirectoryChooserPanel
extends AbstractChooserPanel<File> {
    private static final long serialVersionUID = 6235369491956122980L;
    protected BaseDirectoryChooser m_DirectoryChooser;

    public DirectoryChooserPanel() {
        this("");
    }

    public DirectoryChooserPanel(String path) {
        this(new PlaceholderFile(path));
    }

    public DirectoryChooserPanel(File path) {
        this.setCurrent(path);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DirectoryChooser = new BaseDirectoryChooser();
    }

    @Override
    protected File doChoose() {
        this.m_DirectoryChooser.setSelectedFile((File)this.getCurrent());
        if (this.m_DirectoryChooser.showOpenDialog(this.m_Self) == 0) {
            return this.m_DirectoryChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    protected String toString(File value) {
        return Placeholders.collapseStr(value.getAbsolutePath());
    }

    @Override
    protected File fromString(String value) {
        return new PlaceholderFile(value);
    }

    public void setCurrentDirectory(File value) {
        this.m_DirectoryChooser.setCurrentDirectory(new PlaceholderFile(value));
    }

    public File getCurrentDirectory() {
        return this.m_DirectoryChooser.getCurrentDirectory();
    }

    @Override
    public boolean setCurrent(File value) {
        boolean result = super.setCurrent(new PlaceholderFile(value));
        this.m_DirectoryChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        return result;
    }
}

