/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.option.AbstractOption;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;

public class FileEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected BaseFileChooser m_FileChooser;

    public static String toString(AbstractOption option, Object object) {
        return ((File)object).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new File(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return FileEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return FileEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        File f = (File)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new java.io.File(\"" + f.getName() + "\")";
    }

    @Override
    protected JComponent createCustomEditor() {
        File currentFile = (File)this.getValue();
        this.m_FileChooser = currentFile != null ? new BaseFileChooser() : new BaseFileChooser(new File(System.getProperty("user.dir")));
        this.m_FileChooser.setApproveButtonText("Select");
        this.m_FileChooser.setApproveButtonMnemonic('S');
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_FileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmdString = e.getActionCommand();
                if (cmdString.equals("ApproveSelection")) {
                    File newVal = FileEditor.this.m_FileChooser.getSelectedFile();
                    FileEditor.this.setValue(newVal);
                }
                FileEditor.this.closeDialog();
            }
        });
        return this.m_FileChooser;
    }

    @Override
    protected void initForDisplay() {
        File currentFile = (File)this.getValue();
        if (currentFile != null) {
            this.m_FileChooser.setSelectedFile(currentFile);
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        File f = (File)this.getValue();
        String val = "No file";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }
}

