/*
 * Randomizable.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

/**
 * For classes that support seeded randomization in some sense.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public interface Randomizable {

  /**
   * Sets the seed value.
   * 
   * @param value	the seed
   */
  public void setSeed(long value);

  /**
   * Returns the seed value.
   * 
   * @return  		the seed
   */
  public long getSeed();

  /**
   * Returns the tip text for this property.
   * 
   * @return 		tip text for this property suitable for
   * 			displaying in the GUI or for listing the options.
   */
  public String seedTipText();
}
