/**
 * LogEntryHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

import java.util.List;

/**
 * Interface for classes that store LogEntry records.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2452 $
 */
public interface LogEntryHandler {

  /**
   * Returns the stored LogEntry records.
   *
   * @return		the stored entries
   */
  public List<LogEntry> getLogEntries();

  /**
   * Returns the number of stored LogEntry records.
   *
   * @return		the number of records
   */
  public int countLogEntries();
}
