/*
 * Index.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.db.indices;

import java.util.Vector;

/**
 * An Index is an ordered collection of IndexColumns
 * 
 * @author dale
 * @version $Revision: 1185 $
 */
public class Index extends Vector<IndexColumn>{

  private static final long serialVersionUID = -6266605625222865131L;

  /**
   * Constructor
   *
   */
  public Index() {
    super();
  }

  /**
   * Add IndexColumn to this index. Return index count
   * @param ic	IndexColumn to add
   * @return	current number of indices
   */
  public int addIndexColumn(IndexColumn ic) {
    add(ic);    
    return(size());
  }


  /**
   * Does given Index match this one?
   * @param index	Index to compare
   * @return	equals?
   */
  public boolean equals(Index index) {
    if (index.size() != size()) {
      return(false); 
    }
    for (int i=0;i<index.size();i++) {
      if (!presentAt(i,index.get(i))) {
	return(false);
      }
    }
    return(true);
  }
  
  /**
   * Is given IndexColumn present at given position in collection?
   * @param pos		position
   * @param incol	IndexColumn
   * @return	present?
   */
  public boolean presentAt(int pos,IndexColumn incol) {    
    IndexColumn ic=get(pos);
    if (incol.equals(ic)) {
      return(true);
    }     

    return(false);
  }  
}
