/**
 * ToogleAction.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.action;

import java.awt.event.ActionEvent;

import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;


/**
 * A specialized action class for menu items derived from JCheckBoxMenuItem.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2956 $
 * @see JCheckBoxMenuItem
 */
public class ToggleAction
  extends AbstractBaseAction {

  /** for serialization. */
  private static final long serialVersionUID = 5065335824297443067L;

  /**
   * Defines an <code>Action</code> object with a default
   * description string and default icon.
   */
  public ToggleAction() {
    super();
  }

  /**
   * Defines an <code>Action</code> object with the specified
   * description string and a default icon.
   *
   * @param name	the description
   */
  public ToggleAction(String name) {
    super(name);
  }

  /**
   * Defines an <code>Action</code> object with the specified
   * description string and a the specified icon.
   *
   * @param name	the description
   * @param icon	the icon
   */
  public ToggleAction(String name, Icon icon) {
    super(name, icon);
  }

  /**
   * Defines an <code>Action</code> object with the specified
   * description string and a the specified icon.
   *
   * @param name	the description
   * @param icon	the icon file (without path)
   */
  public ToggleAction(String name, String icon) {
    super(name, icon);
  }

  /**
   * Dummy implementation, does nothing.
   *
   * @param e		ignored
   */
  public void actionPerformed(ActionEvent e) {
    // does nothing
  }
}
