/**
 * FileTypeDeterminingFileChooser.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.chooser;

import java.io.File;

/**
 * Interface for file choosers that support the determination of readers
 * and writers based on filenames (namely extensions).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4129 $
 * @param <R> the type of reader to use
 * @param <W> the type of writer to use
 */
public interface FileTypeDeterminingFileChooser<R, W> {

  /**
   * Returns the reader for the specified file.
   *
   * @param file	the file to determine a reader for
   * @return		the reader, null if none found
   */
  public R getReaderForFile(File file);

  /**
   * Returns the writer for the specified file.
   *
   * @param file	the file to determine a reader for
   * @return		the writer, null if none found
   */
  public W getWriterForFile(File file);
}
