/*
 * RecentFileListener.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.event;

import adams.gui.core.RecentFilesHandler;

/**
 * Interface for classes that listen to events of <code>RecentFilesHandler</code>.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 * @see RecentFilesHandler
 */
public interface RecentFileListener {

  /**
   * Gets called in case a recent file got added.
   * 
   * @param e		the event
   */
  public void recentFileAdded(RecentFileEvent e);

  /**
   * Gets called in case a recent file got selected.
   * 
   * @param e		the event
   */
  public void recentFileSelected(RecentFileEvent e);
}
