/*
 * ItemsRemovedEvent.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.event;

import java.util.EventObject;

/**
 * Event that gets sent when items are to be deleted.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2446 $
 */
public class RemoveItemsEvent
  extends EventObject {

  /** for serialization. */
  private static final long serialVersionUID = 9211592165507512950L;

  /** the indices of the items that were removed. */
  protected int[] m_Indices;

  /**
   * Initializes the object.
   *
   * @param src		the source that triggered the event
   * @param indices	the indices of the items to remove
   */
  public RemoveItemsEvent(Object src, int[] indices) {
    super(src);

    if (indices != null)
      m_Indices = indices.clone();
    else
      m_Indices = null;
  }

  /**
   * Checks whether there are indices stored for this event.
   *
   * @return		true if indices of the items are available
   */
  public boolean hasIndices() {
    return (m_Indices != null);
  }

  /**
   * Returns the stored indices.
   *
   * @return		the indices, can be null if none stored
   */
  public int[] getIndices() {
    return m_Indices;
  }
}
