/**
 * ScriptingTextEditorPanel.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import adams.core.Properties;
import adams.env.Environment;
import adams.env.ScriptingDialogDefinition;
import adams.gui.core.AbstractTextEditorPanelWithSyntaxHighlighting;

/**
 * A text editor panel with syntax highlighting for the scripting commands
 * in the GUI.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3814 $
 */
public class ScriptingTextEditorPanel
  extends AbstractTextEditorPanelWithSyntaxHighlighting {

  /** for serialization. */
  private static final long serialVersionUID = 2811465827523143114L;

  /**
   * Returns the syntax style definition.
   *
   * @return		the props file with the definitions
   */
  protected Properties getStyleProperties() {
    return Environment.getInstance().read(ScriptingDialogDefinition.KEY);
  }
}
