/**
 * RunToolPanel.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.tools;

import adams.db.DatabaseConnection;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngine;

/**
 * A panel for executing tools from the GUI.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class RunToolPanel
  extends AbstractRunToolPanel {

  /** for serialization. */
  private static final long serialVersionUID = -2859158797113257026L;

  /**
   * Returns the current scripting engine, can be null.
   *
   * @return		the current engine
   */
  public AbstractScriptingEngine getScriptingEngine() {
    // DatabaseConnection.getSingleton() is OK, since only run from main GUI
    return ScriptingEngine.getSingleton(DatabaseConnection.getSingleton());
  }
}
