/**
 * ScriptHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.tools.previewbrowser;

import java.awt.BorderLayout;
import java.io.File;
import java.util.List;

import javax.swing.JPanel;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.env.Environment;
import adams.env.ScriptingDialogDefinition;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextPane;
import adams.gui.scripting.SyntaxDocument;

/**
 <!-- globalinfo-start -->
 * Displays the following plain text file types: txt,xml,props
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public class ScriptHandler
  extends AbstractContentHandler {

  /** for serialization. */
  private static final long serialVersionUID = 4859255638148506547L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Displays script files: " + Utils.arrayToString(getExtensions());
  }

  /**
   * Returns the list of extensions (without dot) that this handler can
   * take care of.
   *
   * @return		the list of extensions (no dot)
   */
  public String[] getExtensions() {
    return new String[]{"script", "scr"};
  }

  /**
   * Creates the actual view.
   *
   * @param file	the file to create the view for
   * @return		the view
   */
  protected JPanel createPreview(File file) {
    BasePanel		result;
    BaseTextPane	textPane;
    Properties		props;
    List<String>	lines;

    textPane = new BaseTextPane();
    props    = Environment.getInstance().read(ScriptingDialogDefinition.KEY);
    textPane.setDocument(new SyntaxDocument(props));
    lines    = FileUtils.loadFromFile(file);
    textPane.setText(Utils.flatten(lines, "\n"));

    result = new BasePanel(new BorderLayout());
    result.add(new BaseScrollPane(textPane), BorderLayout.CENTER);

    return result;
  }
}
