/*
 * LatexSpreadSheetWriterTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.core.io;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Tests the adams.core.io.LatexSpreadSheetWriter class. Run from commandline with: <p/>
 * java adams.core.io.LatexSpreadSheetWriter
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3327 $
 */
public class LatexSpreadSheetWriterTest
  extends AbstractSpreadSheetWriterTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public LatexSpreadSheetWriterTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the setup tests.
   *
   * @return		the filenames
   */
  protected String[] getInputFiles() {
    return new String[]{
	"sample.csv",
	"sample2.csv"
    };
  }

  /**
   * Returns the filenames (without path) of the output data files to use
   * in the setup tests.
   *
   * @return		the filenames
   */
  protected String[] getOutputFiles() {
    return new String[]{
	"sample-out.csv",
	"sample2-out.csv"
    };
  }

  /**
   * Returns the setups to use in the setup tests.
   *
   * @return		the setups
   */
  protected AbstractSpreadSheetWriter[] getSetups() {
    LatexSpreadSheetWriter[]	result;

    result = new LatexSpreadSheetWriter[2];

    result[0] = new LatexSpreadSheetWriter();
    result[0].setNumberFormat("#.##");
    result[1] = new LatexSpreadSheetWriter();

    return result;
  }

  /**
   * Returns whether a regression can be run.
   *
   * @return		always true
   */
  protected boolean hasRegressionTest() {
    return true;
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(LatexSpreadSheetWriterTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
