/*
 * NullWriterTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.core.io;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;

/**
 * Tests the adams.core.io.NullWriter class. Run from commandline with: <p/>
 * java adams.core.io.NullWriter
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2208 $
 */
public class NullWriterTest
  extends AbstractTextWriterTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public NullWriterTest(String name) {
    super(name);
  }

  /**
   * Returns the filenames (without path) of the input data files to use
   * in the regression test.
   *
   * @return		the filenames
   */
  protected String[] getRegressionInputFiles() {
    return new String[]{
	"sample.txt"
    };
  }

  /**
   * Returns the names for the input content in the regression test.
   *
   * @return		the names
   */
  protected String[] getRegressionInputNames() {
    return new String[]{
	"dummy"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractTextWriter[] getRegressionSetups() {
    return new NullWriter[]{
	new NullWriter()
    };
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(NullWriterTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
