/**
 * MovingAverageTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.data.conversion.MovingAverage;
import adams.test.TmpFile;

/**
 * Tests the MovingAverage conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3937 $
 */
public class MovingAverageTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public MovingAverageTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    return new Double[]{
	1.0,
	1.2,
	1.3,
	1.23,
	1.1,
	1.04,
	0.99,
	0.98,
	0.94,
	0.9,
	1.0,
	1.1,
	1.2,
	1.15,
	1.2,
	1.3,
	1.18,
	1.08,
	1.01,
	0.95
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    MovingAverage[]	result;

    result    = new MovingAverage[2];
    result[0] = new MovingAverage();
    result[1] = new MovingAverage();
    result[1].setWindowSize(3);

    return result;
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
