/**
 * TimeToStringTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.data.conversion.TimeToString;
import adams.test.TmpFile;

/**
 * Tests the TimeToString conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3942 $
 */
public class TimeToStringTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public TimeToStringTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    return new Object[]{
	1,
	100000,
	123456789,
	1.0,
	100000.0,
	123456789.0
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    TimeToString[]	result;

    result    = new TimeToString[3];
    result[0] = new TimeToString();
    result[1] = new TimeToString();
    result[1].setFormat("dd/MM/yyyy");
    result[2] = new TimeToString();
    result[2].setFormat("HH:mm");

    return result;
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
