/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToDouble;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.flow.transformer.Max;
import adams.flow.transformer.SequenceToArray;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MaxTest
extends AbstractFlowTest {
    public MaxTest(String name) {
        super(name);
    }

    @Override
    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("10.1"), new BaseString("1.3"), new BaseString("-10.9"), new BaseString("987.001")});
        StringToDouble s2d = new StringToDouble();
        Convert con = new Convert();
        con.setConversion((AbstractConversion)s2d);
        SequenceToArray s2a = new SequenceToArray();
        s2a.setArrayLength(4);
        Max actor = new Max();
        Null nul = new Null();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, con, s2a, actor, nul});
        return flow;
    }

    protected void performTest(Double[] dblIn, Integer intOut, Double dblOut) {
        Max actor = new Max();
        actor.setReturnIndex(intOut != null);
        MaxTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        actor.input(new Token((Object)dblIn));
        MaxTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        Token out = actor.output();
        MaxTest.assertNotNull((String)"problem with output()", (Object)out);
        if (intOut != null) {
            Integer intOutActor = (Integer)out.getPayload();
            MaxTest.assertEquals((String)"values differ", (Object)intOut, (Object)intOutActor);
        } else {
            Double dblOutActor = (Double)out.getPayload();
            MaxTest.assertEquals((String)"values differ", (Object)dblOut, (Object)dblOutActor);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorIndex() {
        Double[] dblIn = new Double[]{123.0, 1.0, -3.0, 1001.0};
        for (int i = 0; i < dblIn.length; ++i) {
            this.performTest(dblIn, 3, null);
        }
    }

    public void testActorValue() {
        Double[] dblIn = new Double[]{123.0, 1.0, -3.0, 1001.0};
        for (int i = 0; i < dblIn.length; ++i) {
            this.performTest(dblIn, null, 1001.0);
        }
    }

    public static Test suite() {
        return new TestSuite(MaxTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MaxTest.runTest(MaxTest.suite());
    }
}

