/*
 * SizeOf.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

import sizeof.agent.SizeOfAgent;

/**
 * Helper class for measuring the size of objects using <a href="http://www.jroller.com/maxim/entry/again_about_determining_size_of" target="_blank">Maxim Zakharenkov's SizeOf agent</a>.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3629 $
 */
public class SizeOf {

  /** whether the SizeOf agent is available. */
  protected static Boolean m_SizeOfAgentAvailable;

  /**
   * Returns whether the SizeOf agent is available or not.
   *
   * @return		true if agent available
   */
  public static synchronized boolean isSizeOfAgentAvailable() {
    if (m_SizeOfAgentAvailable == null) {
      try {
	m_SizeOfAgentAvailable = (SizeOfAgent.fullSizeOf(new Integer(1)) > 0);
      }
      catch (Exception e) {
        m_SizeOfAgentAvailable = false;
        System.err.println("SizeOf agent not available! Use '-javaagent:sizeofag.jar' on commandline.");
      }
    }

    return m_SizeOfAgentAvailable;
  }

  /**
   * Returns the size of an object.
   *
   * @param obj		the object to measure
   * @return		the size or -1 if agent not available
   */
  public static int sizeOf(Object obj) {
    if (isSizeOfAgentAvailable())
      return (int) SizeOfAgent.fullSizeOf(obj);
    else
      return -1;
  }

  /**
   * For testing only.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    System.out.println(sizeOf(args));
    System.out.println(sizeOf(new Integer(1)));
    System.out.println(sizeOf(new Double(1.0)));
    System.out.println(sizeOf(new DateFormat("yyyy-MM-dd")));
  }
}
