/*
 * BaseLong.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core.base;

/**
 * Wrapper for a Long object to be editable in the GOE.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 373 $
 */
public class BaseLong
  extends BaseObject {

  /** for serialization. */
  private static final long serialVersionUID = 1247725187608799123L;

  /**
   * Initializes the string with length 0.
   */
  public BaseLong() {
    this("0");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public BaseLong(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		always true
   */
  public boolean isValid(String value) {
    try {
      Long.parseLong(value);
      return true;
    }
    catch (Exception e) {
      return false;
    }
  }

  /**
   * Sets the string value.
   *
   * @param value	the string value
   */
  public void setValue(String value) {
    if (!isValid(value))
      return;

    try {
      m_Internal = Long.parseLong(value);
    }
    catch (Exception e) {
      e.printStackTrace();
      m_Internal = new Long(0);
    }
  }

  /**
   * Returns the current string value.
   *
   * @return		the string value
   */
  public String getValue() {
    return ((Long) m_Internal).toString();
  }

  /**
   * Returns the long value.
   *
   * @return		the long value
   */
  public long longValue() {
    return ((Long) m_Internal).longValue();
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "A long (from " + Long.MIN_VALUE + " to " + Long.MAX_VALUE + ").";
  }
}
