/**
 * ConsoleLog.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.core.io;

/**
 * Simple logger that just outputs the logging information to stdout or stderr.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 529 $
 */
public class ConsoleLog
  extends Log {

  /** for serialization. */
  private static final long serialVersionUID = -3666917058226291266L;

  /**
   * Logs the message.
   *
   * @param msg		the message to log
   * @param out		whether to log default output (= true) or error output (= false)
   * @param newline	whether to add a newline or not
   */
  protected synchronized void doLog(String msg, boolean out, boolean newline) {
    if (out) {
      if (newline)
	System.out.println(msg);
      else
	System.out.print(msg);
    }
    else {
      if (newline)
	System.err.println(msg);
      else
	System.err.print(msg);
    }
  }
}
