/**
 * DebugNestedProducer.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import java.util.Vector;

import adams.flow.core.AbstractExternalActor;

/**
 * Nested producer that outputs format useful for debugging purposes.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3096 $
 */
public class DebugNestedProducer
  extends NestedProducer
  implements DebugOptionProducer {

  /** for serialization. */
  private static final long serialVersionUID = 931016182843089428L;

  /** the property for the external actors. */
  public final static String PROPERTY_EXTERNALACTOR_FILE = "actorFile";

  /**
   * Returns the current value for the option.
   *
   * @param option	the option to get the current value for
   * @return		the current value (can be array)
   */
  protected Object getCurrentValue(AbstractOption option) {
    if (    (option.getOwner().getOwner() instanceof AbstractExternalActor)
	 && option.getProperty().equals(PROPERTY_EXTERNALACTOR_FILE) )
      return ((AbstractExternalActor) option.getOwner().getOwner()).getExternalActor();
    else
      return option.getCurrentValue();
  }

  /**
   * Checks whether the value represents the default value for the option.
   *
   * @param option	the option to check the default value for
   * @param value	the (potential) default value
   * @return		true if the value represents the default value
   */
  protected boolean isDefaultValue(AbstractArgumentOption option, Object value) {
    if (    (option.getOwner().getOwner() instanceof AbstractExternalActor)
	 && option.getProperty().equals(PROPERTY_EXTERNALACTOR_FILE) )
      return false;
    else
      return option.isDefaultValue(value);
  }

  /**
   * Visits an argument option.
   *
   * @param option	the argument option
   * @return		the last internal data structure that was generated
   */
  public Vector processOption(AbstractArgumentOption option) {
    Vector		result;
    Vector		nested;
    NestedProducer	producer;
    Object		current;

    if (option.getProperty().equals(PROPERTY_EXTERNALACTOR_FILE)) {
      current = getCurrentValue(option);
      result = new Vector();
      if (getUsePropertyNames())
	result.add(getOptionIdentifier(option) + "Expanded");
      else
	result.add(getOptionIdentifier(option) + "-expanded");
      if (current != null) {
	producer = new DebugNestedProducer();
	nested   = producer.produce((OptionHandler) current);
      }
      else {
	nested = new Vector();
	nested.add("null");
      }
      result.add(nested);

      if (m_Nesting.empty())
	m_Output.addAll(result);
      else
	((Vector) m_Nesting.peek()).addAll(result);
    }
    else {
      result = super.processOption(option);
    }

    return result;
  }
}
