/*
 * ChromatogramUtils.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.data.container;

/**
 * Utility class for data containers.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1806 $
 */
public abstract class DataContainerUtils {

  /** for serialization. */
  private static final long serialVersionUID = -2761169412400730349L;

  /**
   * An enumeration of types of gap-filling.
   *
   * @author  fracpete (fracpete at waikato dot ac dot nz)
   * @version $Revision: 1806 $
   */
  public enum GapFilling {
    /** nothing is done. */
    NOTHING,
    /** adds data points with the original y. */
    ORIGINAL,
    /** adds data points with zero y. */
    ZERO,
    /** adds data points with abundances that are on a straight line connecting
     * the borders of the gap. */
    CONNECT
  }
}
