/*
 * PassThrough.java
 * Copyright (C) 2008-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.data.noise;

import adams.data.container.DataContainer;

/**
 <!-- globalinfo-start -->
 * A dummy denoiser, which removes no noise at all.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 * <pre>-regions (property: recordRegions)
 *         If set to true, the noisy regions will be recorded as well.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2320 $
 */
public class PassThrough
  extends AbstractDenoiser {

  /** for serialization. */
  private static final long serialVersionUID = 6019995704005696521L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "A dummy denoiser, which removes no noise at all.";
  }

  /**
   * Performs the actual denoising - just copies the input data to the output.
   *
   * @param data	the data to process
   * @return		the denoised data
   */
  protected DataContainer processData(DataContainer data) {
    return (DataContainer) data.getClone();
  }
}
