/**
 * DataTypeHelper.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

import adams.data.report.Field;

/**
 * Helper for the DataType class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3436 $
 */
public class DataTypeHelper {

  /**
   * Determines the type identifier for an object (S=String, B=Boolean,
   * N=Double; default is 'S').
   *
   * @param o		the object to get the type for
   * @return		the type
   */
  public static String typeFor(Object o) {
    String	result;

    result = "S";

    if (o instanceof Boolean)
      result = "B";
    else if (o instanceof Double)
      result = "N";

    return result;
  }

  /**
   * Converts the object into the appropriate string.
   *
   * @param o		the object to convert
   * @return		the generated string
   */
  public static String convert(Object o) {
    String	result;
    String	type;

    type = typeFor(o);

    if (type.equals("S"))
      result = Field.fixString(((String) o).replace("\\", "/"));
    else if (type.equals("B"))
      result = o.toString();
    else if (type.equals("N"))
      result = o.toString();
    else
      throw new IllegalArgumentException("Unhandled type '" + type + "'!");

    return result;
  }
}
