/**
 * LogEntryMutableHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

/**
 * Interface for classes that allow the internally stored list of LogEntry
 * records to be modified from outside.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2452 $
 */
public interface MutableLogEntryHandler
  extends LogEntryHandler {

  /**
   * Removes all currently stored LogEntry records.
   */
  public void clearLogEntries();

  /**
   * Adds the LogEntry record to the internal list.
   *
   * @param entry	the record to add
   */
  public void addLogEntry(LogEntry entry);

  /**
   * Returns the specified LogEntry record.
   *
   * @param index	the index of the record to return
   * @return		the requested LogEntry
   */
  public LogEntry getLogEntry(int index);

  /**
   * Removes the specified LogEntry record from the internal list.
   *
   * @param index	the index of the record to delete
   * @return		the deleted LogEntry
   */
  public LogEntry removeLogEntry(int index);
}
