/*
 * FlowSetupChangeEvent.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.event;

import java.util.EventObject;

import adams.flow.setup.FlowSetup;

/**
 * Event that gets sent by a FlowSetup when the execution of a flow has 
 * started, finished, etc.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 628 $
 */
public class FlowSetupStateEvent
  extends EventObject {

  /** for serialization. */
  private static final long serialVersionUID = -113405042251910190L;

  /**
   * The type of event.
   * 
   * @author  fracpete (fracpete at waikato dot ac dot nz)
   * @version $Revision: 628 $
   */
  public static enum Type {
    /** flow was modified. */
    MODIFIED,
    /** flow started. */
    STARTED,
    /** successfully finished. */
    FINISHED,
    /** an error occurred. */
    ERROR;
  }
  
  /** the type of event. */
  protected Type m_Type;
  
  /**
   * Initializes the event.
   * 
   * @param source	the setup that triggered the event
   * @param type	the type of event
   */
  public FlowSetupStateEvent(FlowSetup source, Type type) {
    super(source);
    
    m_Type = type;
  }
  
  /**
   * Returns the setup that triggered the event.
   * 
   * @return		the setup
   */
  public FlowSetup getFlowSetup() {
    return (FlowSetup) getSource();
  }
  
  /**
   * Returns the type of event.
   * 
   * @return		the type
   */
  public Type getType() {
    return m_Type;
  }
}
