/*
 * JobListCompleteListener.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.event;

import java.io.Serializable;


/**
 * Interface for classes that listen for queues to finish all of its jobs.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1247 $
 */
public interface JobListCompleteListener
  extends Serializable {
  
  /**
   * Post process jobs in the queue.
   * 
   * @param e		the event
   */
  public void queueCompleted(JobListCompleteEvent e);
}
