/**
 * StorageName.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.control;

import adams.core.base.BaseString;

/**
 * Wrapper around the name of a storage item (= string).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3276 $
 */
public class StorageName
  extends BaseString {

  /** for serialization. */
  private static final long serialVersionUID = 3909330668809621538L;

  /**
   * Initializes the name with a default value.
   */
  public StorageName() {
    this("storage");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public StorageName(String s) {
    super(s);
  }
}
