/**
 * EventReference.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

import adams.core.base.BaseString;

/**
 * Wrapper around the name of an event (= string).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4255 $
 */
public class EventReference
  extends BaseString {

  /** for serialization. */
  private static final long serialVersionUID = 7037481336505908036L;

  /**
   * Initializes the string with length 0.
   */
  public EventReference() {
    this("");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public EventReference(String s) {
    super(s);
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "The name of an event.";
  }
}
