/*
 * InputProcessor.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.core;

/**
 * Interface for flow actors that can process input tokens.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public interface InputConsumer {
  
  /**
   * Returns the class that the consumer accepts.
   * 
   * @return		the Class of objects that can be processed
   */
  public Class[] accepts();

  /**
   * The method that accepts the input token and then processes it.
   * 
   * @param token	the token to accept and process
   */
  public void input(Token token);
}
