/**
 * PropertyHelper.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

import java.beans.PropertyDescriptor;
import java.io.File;

/**
 * Helper class for updating properties of objects.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3069 $
 */
public class PropertyHelper {

  /**
   * Converts the variable value into the appropriate object, if possible.
   *
   * @param desc	the property descriptor to use
   * @param value	the string to convert
   * @return		the converted value or null if it cannot be converted
   */
  public static Object convertVariableValue(PropertyDescriptor desc, String value) {
    Object	result;
    Class	cls;

    result = null;
    cls    = desc.getReadMethod().getReturnType();

    // boolean
    if ((cls == Boolean.class) || (cls == Boolean.TYPE))
      result = new Boolean(value);
    // byte
    else if ((cls == Byte.class) || (cls == Byte.TYPE))
      result = new Byte(value);
    // short
    else if ((cls == Short.class) || (cls == Short.TYPE))
      result = new Short(value);
    // integer
    else if ((cls == Integer.class) || (cls == Integer.TYPE))
      result = new Integer(value);
    // long
    else if ((cls == Long.class) || (cls == Long.TYPE))
      result = new Long(value);
    // float
    else if ((cls == Float.class) || (cls == Float.TYPE))
      result = new Float(value);
    // double
    else if ((cls == Double.class) || (cls == Double.TYPE))
      result = new Double(value);
    // String
    else if (cls == String.class)
      result = value;
    // File
    else if (cls == File.class)
      result = new File(value);

    if (result == null)
      System.err.println(
	  "Class " + cls.getName() + " not (yet) supported for setting property!");

    return result;
  }

}
