/**
 * DummySource.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.template;

import adams.flow.core.AbstractActor;
import adams.flow.source.StringConstants;

/**
 <!-- globalinfo-start -->
 * A dummy source template, used as default by the TemplateSource actor.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 * 
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to 
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 * 
 * <pre>-name &lt;java.lang.String&gt; (property: name)
 * &nbsp;&nbsp;&nbsp;The new name for the actor; leave empty to use current.
 * &nbsp;&nbsp;&nbsp;default: 
 * </pre>
 * 
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4447 $
 */
public class DummySource
  extends AbstractActorTemplate {

  /** for serialization. */
  private static final long serialVersionUID = 4780085282410175616L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "A dummy source template, used as default by the TemplateSource actor.";
  }

  /**
   * Generates the actor.
   *
   * @return 		the generated actor
   */
  protected AbstractActor doGenerate() {
    return new StringConstants();
  }
}
