/**
 * CustomSearchTableModel.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.core;

import javax.swing.table.TableModel;

/**
 * Interface for table models that customize how the search identifies a
 * match.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1653 $
 */
public interface CustomSearchTableModel
  extends TableModel {

  /**
   * Tests whether the search matches the specified row.
   *
   * @param params	the search parameters
   * @param row		the row of the underlying, unsorted model
   * @return		true if the search matches this row
   */
  public boolean isSearchMatch(SearchParameters params, int row);
}
