/*
 * EventsNode.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.eventstree;

import adams.flow.standalone.Events;
import adams.gui.goe.actorpathtree.ActorPathNode;

/**
 * Specialized tree node.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4259 $
 */
public class EventsNode
  extends ActorPathNode {

  /** for serialization. */
  private static final long serialVersionUID = 7329048118794889190L;

  /**
   * Initializes the class node with the specified label (package or class
   * name).
   *
   * @param label	the label for this node
   */
  public EventsNode(String label) {
    super(label);
  }

  /**
   * Returns whether this node represents an event.
   *
   * @return		true if an event
   */
  public boolean isEvent() {
    return ((m_Classname != null) && !m_Classname.equals(Events.class.getName()));
  }
}