/*
 * GarbageCollector.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;

/**
 * Runs the garbage collector.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2665 $
 * @see adams.core.management.GarbageCollector
 */
public class GarbageCollector
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = -2688798836965476377L;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public GarbageCollector(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "duke.png";
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    System.gc();
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "Garbage collector";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.DEVELOPER;
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return CATEGORY_HELP;
  }
}